/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import static gov.va.med.mhv.usermgmt.common.enums.AccessDomainEnum.BBGUI;
import static gov.va.med.mhv.usermgmt.common.enums.AccessDomainEnum.MYGOALS;
import static gov.va.med.mhv.usermgmt.common.enums.AccessDomainEnum.NEWPHR;
import static gov.va.med.mhv.usermgmt.common.enums.AccessDomainEnum.PHR;
import static gov.va.med.mhv.usermgmt.common.enums.AccessDomainEnum.SECUREMESSAGING;

import gov.va.med.mhv.usermgmt.common.enums.AccessDomainEnum;

/**
 * @author PII
 *
 */
public final class AccessDomainUtils {

    /**
     * 
     */
    private AccessDomainUtils() {
    }
    
    public static boolean isPHR(AccessDomainEnum accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return PHR.equals(accessDomain);
    }

    public static boolean isPHR(String accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return PHR.getAccessName().equals(accessDomain);
    }

    public static boolean isPHR(int accessDomain) {
        return PHR.getAccessId() == accessDomain;
    }
    
    public static boolean isSM(AccessDomainEnum accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return SECUREMESSAGING.equals(accessDomain);
    }

    public static boolean isSM(String accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return SECUREMESSAGING.getAccessName().equals(accessDomain);
    }

    public static boolean isSM(int accessDomain) {
        return SECUREMESSAGING.getAccessId() == accessDomain;
    }
    
    public static boolean isMyGoals(AccessDomainEnum accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return MYGOALS.equals(accessDomain);
    }

    public static boolean isMyGoals(String accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return MYGOALS.getAccessName().equals(accessDomain);
    }

    public static boolean isMyGoals(int accessDomain) {
        return MYGOALS.getAccessId() == accessDomain;
    }
    
    public static boolean isBBGUI(AccessDomainEnum accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return BBGUI.equals(accessDomain);
    }

    public static boolean isBBGUI(String accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return BBGUI.getAccessName().equals(accessDomain);
    }

    public static boolean isBBGUI(int accessDomain) {
        return BBGUI.getAccessId() == accessDomain;
    }
    
    // NEW PHR Element Check
    public static boolean isNewPhr(AccessDomainEnum accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return NEWPHR.equals(accessDomain);
    }

    public static boolean isNewPhr(String accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return NEWPHR.getAccessName().equals(accessDomain);
    }

    public static boolean isNewPhr(int accessDomain) {
        return NEWPHR.getAccessId() == accessDomain;
    }    
    
}
